﻿//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SID_monitor
{
	partial class SunriseSunsetTimes : Form
	{
		public SunriseSunsetTimes()
		{
			InitializeComponent();
		}

		private SunriseSunset SunriseSunsetValues;


		private void UpdateFormValues() {
			this.labelLocation.Text = SID_monitor.Properties.Settings.Default.LatHemi + " "
                + SID_monitor.Properties.Settings.Default.LatDeg.ToString() + "° "
                + SID_monitor.Properties.Settings.Default.LatMins.ToString() + "' "
                + SID_monitor.Properties.Settings.Default.LatSecs.ToString() + "\"  "
                + SID_monitor.Properties.Settings.Default.LongHemi + " "
                + SID_monitor.Properties.Settings.Default.LongDeg.ToString() + "° "
                + SID_monitor.Properties.Settings.Default.LongMins.ToString() + "' "
                + SID_monitor.Properties.Settings.Default.LongSecs.ToString() + "\"";
			this.labelAMAstroTw.Text = SunriseSunsetValues.MorningAstronomicalTwilight;
			this.labelAMNautiTw.Text = SunriseSunsetValues.MorningNauticalTwilight;
			this.labelAMCivilTw.Text = SunriseSunsetValues.MorningCivilTwilight;
			this.labelSunrise.Text = SunriseSunsetValues.SunriseTime;
			this.labelNoonTime.Text = SunriseSunsetValues.NoonTime;
			this.labelMaxSunAlt.Text = SunriseSunsetValues.SunMaxAlt ;
            this.labelMinSunAlt.Text = SunriseSunsetValues.SunMinAlt; 
            this.labelDaylength.Text = SunriseSunsetValues.DayLength;
			this.labelSunset.Text = SunriseSunsetValues.SunsetTime;
			this.labelPMCivilTw.Text = SunriseSunsetValues.EveningCivilTwilight;
			this.labelPMNautiTw.Text = SunriseSunsetValues.EveningNauticalTwilight;
			this.labelPMAstroTw.Text = SunriseSunsetValues.EveningAstronomicalTwilight;

		}

		private void SunriseSunsetTimes_Load(object sender, EventArgs e)
		{
			this.dateTimePicker.Value = DateTime.UtcNow;
		}

		private void dateTimePicker_ValueChanged(object sender, EventArgs e)
		{
			SunriseSunsetValues = new SunriseSunset(this.dateTimePicker.Value);
			UpdateFormValues();
		}

		private void buttonOK_Click(object sender, EventArgs e)
		{
			this.Close();
		}
      
	}
}